/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.soap.transport;

import filenet.vw.base.logging.Logger;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.http.SOAPHTTPConnection;

public class VWSOAPHTTPConnection
extends SOAPHTTPConnection {
    private String creds = null;
    private String sessionId = null;
    private static Logger logger = Logger.getLogger("filenet.vw.soap.transport");
    private static final String m_className = "VWSOAPHttpConnection";

    public VWSOAPHTTPConnection(String creds, String sessionId) {
        this.creds = creds;
        this.sessionId = sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    protected void sendMe(URL sendTo, String action, Hashtable headers, Envelope env, SOAPMappingRegistry smr, SOAPContext ctx) throws SOAPException {
        super.send(sendTo, action, headers, env, smr, ctx);
    }

    public void send(URL sendTo, String action, Hashtable headers, Envelope env, SOAPMappingRegistry smr, SOAPContext ctx) throws SOAPException {
        String m_method = "send";
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String httpProxyHost = System.getProperty("http.proxyHost");
                if (httpProxyHost != null && httpProxyHost.trim().length() == 0) {
                    if (logger.isFinest()) {
                        logger.finest(VWSOAPHTTPConnection.m_className, "send", "Removing emptyhttp.proxyHost");
                    }
                    System.getProperties().remove("http.proxyHost");
                }
                return null;
            }
        });
        if (headers == null) {
            headers = new Hashtable<String, String>();
        }
        if (this.creds != null) {
            headers.put("X-Authorization", this.creds);
        }
        if (this.sessionId != null) {
            headers.put("Cookie", this.sessionId);
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "send", ">>>>>>>>>>> SENT HEADERS:" + headers);
        }
        try {
            AccessController.doPrivileged(new privAction(this, sendTo, action, headers, env, smr, ctx));
        }
        catch (PrivilegedActionException pae) {
            Exception ex = pae.getException();
            if (ex instanceof SOAPException) {
                throw (SOAPException)((Object)ex);
            }
            throw new SOAPException("Client", "Exception sending", (Throwable)pae.getException());
        }
        this.sessionId = (String)this.getHeaders().get("Cookie");
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setProperty("filenet.vw.soap.transport.enabled", "true");
                return null;
            }
        });
    }

    class privAction
    implements PrivilegedExceptionAction {
        protected URL sendTo;
        protected String action;
        protected Hashtable headers;
        protected Envelope env;
        protected SOAPMappingRegistry smr;
        protected SOAPContext ctx;
        protected VWSOAPHTTPConnection SOAPHTTP;

        public privAction(VWSOAPHTTPConnection SOAPHTTP, URL sendTo, String action, Hashtable headers, Envelope env, SOAPMappingRegistry smr, SOAPContext ctx) {
            this.SOAPHTTP = SOAPHTTP;
            this.sendTo = sendTo;
            this.action = action;
            this.headers = headers;
            this.env = env;
            this.smr = smr;
            this.ctx = ctx;
        }

        public Object run() throws SOAPException {
            this.SOAPHTTP.sendMe(this.sendTo, this.action, this.headers, this.env, this.smr, this.ctx);
            return null;
        }
    }
}

